.386P
.MODEL FLAT,C
IDEAL

UDATASEG
;_TEXT SEGMENT DWORD PUBLIC 'CODE'
;        ASSUME CS:_TEXT,DS:_DATA

randseed dd ?

CODESEG
public GeneratePlasmaTexture

;random          PROC NEAR
PROC random

                push edx
                mov eax,015A4E35h
                imul eax,[randseed]
                inc eax
                mov [randseed],eax ; randseed= 0x15A4E35*randseed + 1
                sar eax,16
                imul eax,ebx
                pop  edx
                ret

;random          ENDP
ENDP

;storepixel      PROC NEAR
PROC storepixel

                and ebx,0FFFFh
                mov ax,di
                shr ax,2 ; AX:= pixel/4
                test ax,0FF00h
                jz isok
                xor al,al
                test ax,ax
                jns notneg
                dec al
notneg:         mov [esi + ebx],al
                ret
isok:           mov [esi + ebx],al
                ret

;storepixel      ENDP
ENDP

;initpixel       PROC NEAR
PROC initpixel

                ;mov di,0;2
                call random
                shr eax,16
                mov di,ax
                ;add di,ax ; DI:= 2 + rand()
                mov ebx,ecx
; Note: there is no RET because the next routine must always execute after
; this one. So don't wonder, it's no bug, it saves some bytes!

;initpixel       ENDP
ENDP

;addb            PROC NEAR
PROC addb

                and ebx,0FFFFh
                mov al,[byte ptr esi + ebx]
                xor ah,ah
                add di,ax ; pixel:= pixel + ESI:EBX
                mov ebx,ecx
                ret

;addb            ENDP
ENDP

passtbl: dd offset pass1
         dd offset pass2
         dd offset pass3

;makeplasma      PROC NEAR
PROC GeneratePlasmaTexture
local pval:dword, m: dword, m2: dword, pass:dword
                ; parameterek: ESI:= destptr, EDX:= randseed, EAX:= roughness

                pushad
                mov [randseed],edx ; randseed lementese

                ; inicializalas:
                and eax,0000FFFFh
                mov [pval],eax
                mov edx,offset addb
                mov ebx,1
                call random
                mov [esi],al

                mov [m2],256
                mov [m],8080h

@@finestep:
                xor ecx,ecx
                mov [pass],ecx
@@passloop:
                xor ecx,ecx
@@yloop:
                xor cl,cl
@@xloop:
                mov eax,[pass]
                mov ebx,[pval]
                jmp [dword ptr passtbl + eax*4] ; EAX. pass-ra ugras

pass1:          lea ebx,[ebx + ebx*2] ; EBX*= 3
                call initpixel
                mov ebx,ecx
                add bh,[byte ptr m2]
                call edx
                add bl,[byte ptr m2]
                call edx
                add bh,[byte ptr m2]
                add bl,[byte ptr m2]
                call edx
                add ebx,[m]
                jmp passfinished

pass2:          call initpixel
                mov  ebx,ecx
                add  bh,[byte ptr m]
                sub  bl,[byte ptr m]
                call edx ; addb
                add  ebx,[m]
                call edx ; addb
                add  bh,[byte ptr m2]
                call edx ; addb
                add  bh,[byte ptr m]
                jmp  passfinished

pass3:          call initpixel
                mov  ebx,ecx
                sub  bh,[byte ptr m]
                add  bl,[byte ptr m]
                call edx ; addb
                add  bl,[byte ptr m2]
                call edx ; addb
                add  ebx,[m]
                call edx ; addb
                add  bl,[byte ptr m]

passfinished:
                call storepixel

                add cl,[byte ptr m2]
                jnz short @@xloop

                add ch,[byte ptr m2]
                jnz short @@yloop

                mov cl,2
                inc [pass]
                cmp [pass],ecx
                jbe @@passloop

                shr [pval],1
                shr [m2],1
                shr [m],1
                cmp [m2],ecx
                jae @@finestep
                popad

                ret

;makeplasma      ENDP
ENDP

;_TEXT ENDS

END